#!/usr/bin/env python
"""
Pie Man
Gra na Raspberry Pi
"""
import time                     # Na potrzeby dodawania opóźnień
import os, pygame, sys
import random, copy

pygame.init()                   # Inicjowanie interfejsu graficznego
pygame.mixer.quit()
pygame.mixer.init(frequency=22050, size=-16, channels=2, buffer=512)
eatSound = pygame.mixer.Sound("sounds/eatPill.ogg")
ppSound = pygame.mixer.Sound("sounds/powerPill.ogg")
ghostDieSound = pygame.mixer.Sound("sounds/ghostDie.ogg")
pieDieSound = pygame.mixer.Sound("sounds/pieDie.ogg")
pieStartSound = pygame.mixer.Sound("sounds/pieStart.ogg")

os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Pie Man")
pygame.event.set_allowed(None)
pygame.event.set_allowed([pygame.KEYDOWN,pygame.QUIT])
textHeight = 36
font = pygame.font.Font(None, textHeight)

screenWidth = 1000
screenHeight =636
playWidth = 800
screenOffset = (screenWidth - playWidth) / 2
screen = pygame.display.set_mode([screenWidth,screenHeight],0,32)
background = pygame.Surface((playWidth,screenHeight))
pillsLayer = pygame.Surface((playWidth,screenHeight))

picName = [ "pie1left","pie2left","pie1right","pie2right","pie1up","pie2up","pie1down","pie2down" ]
piPicture = [ pygame.image.load("pies/"+picName[frame]+".png").convert_alpha() for frame in range(0,8)]

ghost2Picture = [ pygame.image.load("pies/g"+str(frame)+"o.png").convert_alpha() for frame in range(1,7)]
ghost1Picture = [ pygame.image.load("pies/g"+str(frame)+"r.png").convert_alpha() for frame in range(1,7)]
ghostbPicture = [ pygame.image.load("pies/g"+str(frame)+"b.png").convert_alpha() for frame in range(1,7)]
ghostdPicture = [ pygame.image.load("pies/g"+str(frame)+"d.png").convert_alpha() for frame in range(1,9)]

# Definiowanie kolorów interfejsu użytkownika
cBackground =(0,0,0)
cText = (255,255,255)
cBlock = (0,0,0)
blue = (0,0,255,255)
pillColour =(255,255,0,255)
box = [screenWidth-100,screenHeight-40]
hw = screenWidth / 2
hh = screenHeight /2
pieIncrement = 8 # Szybkość Pie Mana
pieDirection = 2
step = 0  # Zmiana rysunku Pie Mana
gStep = 0 # Zmiana rysunku ducha
gIncrement = 1 
score = 0
hiScore = 0
eaten = 0 # Liczba zjedzonych pigułek
ppill = False
maxLives = 3
lives = maxLives
pieMan = 48 # Wielkość boku Pie Mana (w pikselach)
rightLimit = playWidth+screenOffset-pieMan
position = [screenOffset +pieIncrement*2,pieIncrement+2] # Pozycja Pie Mana
ghostInitalPos = [ [526,298], [422,298] ]
ghostPos = copy.deepcopy(ghostInitalPos)
ghostRelease = time.time()
gNumber = 0
ghostDirection = [0, 2]
moved = True
start = False
powerPlay = False
ppCount = 90

def main():
   global position, step, gStep, gIncrement, ghostPos, moved, ghostRelease, pieDirection
   global score, ghostDirection, cBackground, hiScore, lives, eaten, gNumber, start, ppCount, powerPlay
   while True:
     score = 0
     eaten = 0
     lives = maxLives
     pieDirection = 2
     setupBackground()
     updateLives()
     ghostPos = copy.deepcopy(ghostInitalPos) # Duchy wracają do wyjściowej lokalizacji
     position = [screenOffset +pieIncrement*2,pieIncrement+2] # Pozycja Pie Mana          
     drawScreen(position,ghostPos[0],ghostPos[1])     
     gNumber = 0
     ppCount = 90
     start = False
     pieStartSound.play()
     while not start: # Oczekiwanie na wciśnięcie klawisza
        checkForEvent()
     ghostRelease = time.time()+ 4.0 # Czas do wypuszczenia pierwszego ducha
     while lives > 0:            
            checkForEvent()
            if ppCount < 80: # Długość trwania trybu mocy
               if ppCount >70 and ppCount < 75: # Migotanie przed zakończeniem trybu mocy
                  powerPlay=False
               else:   
                  powerPlay=True
            else:
               powerPlay=False
            drawScreen(position,ghostPos[0],ghostPos[1])
            kill(position,ghostPos[0],ghostPos[1]) # Wykrywanie spotkania z duchem
            eat(position)
            position = makeStep(position,pieDirection, pieIncrement)
            # Ruchy duchów
            if powerPlay :
               ghostInc = 4
            else:
               ghostInc = 8
            if time.time() > ghostRelease:
               if gNumber < 2:
                  ghostRelease = time.time()+ 5.0 # Czas do wypuszczenia następnego ducha
                  gNumber += 1
            for i in range(0,gNumber):
              new = getNewDir(i)
              ghostPos[i] = makeStep(ghostPos[i],new, ghostInc)
              if not moved:
                 ghostPos[i] = makeStep(ghostPos[i],ghostDirection[i], ghostInc)
                 while not moved:
                     ghostDirection[i] = random.randint(0,3)<<1
                     ghostPos[i] = makeStep(ghostPos[i],ghostDirection[i], ghostInc)
              else:   
                 ghostDirection[i] = new
               
            step ^= 1 # Animacja Pie Mana
            ppCount +=1 # Pomiar upływu trybu mocy
            gStep +=gIncrement
            if gStep == 5 or gStep == 0:
               gIncrement = -gIncrement
     # Koniec gry
     if score > hiScore : # Nowy rekord jest wyróżniany migotaniem
        hiScore = score
        for i in range (0,15):
          cBackground = ( (i & 1)*255, ((i>>1) & 1)*255,((i>>2) & 1)*255)  
          drawWords(str(hiScore),screenOffset+playWidth,textHeight*2)
          pygame.display.update()
          time.sleep(0.2)
     cBackground = (0,0,0)
     drawWords(str(hiScore),screenOffset+playWidth,textHeight*2)
     pygame.display.update()
     time.sleep(2.0)
